/******************************************************************************/
/* Touch Pad Header for ADS7843 			     							  */
/* Developer : Ramin Jafarpour 									  			  */
/*                                    www.ECA.ir                              */  
/******************************************************************************/

#include <stdio.h>
#include "Touch.h"
#include "TFTLCD.h"

#define mirror_y

// Calibrates for LCD Touch
#define max_xx  3780
#define max_yy  3790
#define min_xx  255
#define min_yy  350

#define x_range (max_xx - min_xx)
#define y_range (max_yy - min_yy)


//  25-->1.2us 50-->2.25us
static void spi_delay(void)
{
    volatile unsigned int dl;
    for(dl=0;dl<25;dl++);
}


unsigned char SPI_WriteByte(unsigned char data)
{
    unsigned char r_data = 0;
    unsigned int i;
    for(i=0;i<8;i++)
    {
        if( data & (1<<7))
        {
            MOSI_HIGH();
        }
        else
        {
            MOSI_LOW();
        }
        data <<= 1;
        spi_delay();
        SCK_HIGH();
        if( MISO_value() )
        {
            r_data++;
        }
        r_data <<= 1;
        spi_delay();
        SCK_LOW();
    }
    return r_data;
} 

char touch_get(int *x,int *y)
{
    unsigned short tmpx[10];
    unsigned short tmpy[10];
    unsigned short touch_x,touch_y;
    unsigned int i;
  
    if ( TP_DOWN() )
    {
        for(i=0; i<10; i++)
        {
            TP_CS_LOW();
            SPI_WriteByte(TOUCH_MSR_X);                            // read X 
            tmpx[i] = SPI_WriteByte(0x00)<<4;                      // read MSB bit[11:8] 
            tmpx[i] |= ((SPI_WriteByte(TOUCH_MSR_Y)>>4)&0x0F );    // read LSB bit[7:0] and prepare read Y 
            tmpy[i] = SPI_WriteByte(0x00)<<4;                      // read MSB bit[11:8] 
            tmpy[i] |= ((SPI_WriteByte(0x00)>>4)&0x0F );           // read LSB bit[7:0] 
            SPI_WriteByte( 1<<7 ); 
            TP_CS_HIGH();
        }

        
        {
            unsigned int min_x = 0xFFFF,min_y = 0xFFFF;
            unsigned int max_x = 0,max_y = 0;
            unsigned int total_x = 0;
            unsigned int total_y = 0;
            unsigned int i;

            for(i=0; i<10; i++)
            {
                if( tmpx[i] < min_x )
                {
                    min_x = tmpx[i];
                }
                if( tmpx[i] > max_x )
                {
                    max_x = tmpx[i];
                }
                total_x += tmpx[i];

                if( tmpy[i] < min_y )
                {
                    min_y = tmpy[i];
                }
                if( tmpy[i] > max_y )
                {
                    max_y = tmpy[i];
                }
                total_y += tmpy[i];
            }
            total_x = total_x - min_x - max_x;
            total_y = total_y - min_y - max_y;
            touch_x = total_x / 8;
            touch_y = total_y / 8;
        }
		if (touch_y<max_yy+10) *y = touch_y-min_yy;
		else touch_y=0;
		if(touch_x<max_xx+10)  *x = touch_x-min_xx;
		else touch_x=0;

		if ((touch_x!=0)&&(touch_y!=0))return 1;
		else return 0;

    }else return 0;                  
}


void TouchInit(void)
{

    LPC_GPIO2->FIODIR      &= ~(1 << 13);    /* PORT2.13 defined as input       */
    LPC_GPIOINT->IO2IntEnF |=  (1 << 13);    /* enable falling edge irq         */
    //NVIC_EnableIRQ(EINT3_IRQn);              /* enable irq in nvic              */

    LPC_GPIO0->FIODIR |=  (1<<6); // P0.6 CS is output
    TP_CS_HIGH();

    //SPI config,CPOL=0,CPHA=0
    LPC_GPIO0->FIODIR &= ~(1<<8); // P0.8 MISO input
    LPC_GPIO0->FIODIR |=  (1<<7) | (1<<9); // P0.7 SCK,P0.9 MOSI is output
    SCK_LOW();

    TP_CS_LOW();
    SPI_WriteByte( 1<<7 );
    TP_CS_HIGH();

}

char Touch(unsigned short *X,unsigned short *Y)
{
    int touch_x,touch_y;
	volatile unsigned int ti;
	char x_str[20];
    char y_str[20];


    if( TP_DOWN() )
    {
			if (touch_get(&touch_x,&touch_y)) 
			{
				touch_x = (touch_x*240/x_range);
				if (touch_x<0) touch_x=0;
				else if (touch_x>240) touch_x=240;  
#ifdef mirror_y
				touch_y = (touch_y*320/y_range);
#else 
			    touch_y = 320-(touch_y*320/y_range);
#endif
				if (touch_y<0) touch_y=0;
				else if (touch_y>320) touch_y=320;
            	sprintf(x_str,"X:%03d",touch_x);
            	sprintf(y_str,"Y:%03d",touch_y);
				*X = touch_x;
				*Y = touch_y;
				return 1;
			}			
    }
	return 0;
	

}
